<?php if (basename(__FILE__) == basename($_SERVER["SCRIPT_FILENAME"])) die ("Please don't do that.");?>
<?php get_header();
/*
Template name: Section layout
*/

// Remove posts from the second query if they are shown in the slider.
// Added as a filter to posts_where
function excludePostsFromSlider($content) {
	global $wpdb,$prevSlider;
	$excludes = implode(",",array_filter((array)$prevSlider,create_function('$a','return is_numeric($a);')));
	if ($excludes != "") {
		return $content." AND $wpdb->posts.ID NOT IN ($excludes)" ;
	} else {
		return $content;
	}
}?>

<div id="content">
	<div id="posts" class="section">
	<?php

/* Scroller section */
$postID = $post->ID;
$ICITposts = new WP_Query("showposts=3&taxonomy=spectaculahighlight&term=page-{$postID}");
$wp_query->is_page = null;
$wp_query->is_category = true;
if (is_object($ICITposts) && $ICITposts->have_posts()) { ?>
	<div id="scroller">
		<div id="scrollerWindow">
			<div class="pause"><img src="<?php bloginfo("template_url");?>/images/pause.png" alt="<?php _e('pause',THEMENAME);?>" /></div>
			<dl>
			<?php
				$highlightTitles = array();
				while ($ICITposts->have_posts()) {
					$ICITposts->the_post();

					$previousday = null; // WP won't return the day if it was the same as the last one unless this is killed.
					$highlightTitles[] = array(		get_the_title(),
													get_permalink(),
													get_the_time(),
													the_date (null,null,null,false),
													$post->ID
												);
					$prevSlider[] = $post->ID;
					$image = (function_exists('PIPPGetImage') ? PIPPGetImage('spectaculahighlight',$post->ID,false,true) : null);?>

					<dd>
						<?php echo ($image ? ' <img src="'.$image.'" alt="'.get_the_title().'"/>' : "");?>
						<?php the_title("<h3><a href=\"".get_permalink()."\">","</a></h3>");?>
						<div class="scrollerContentText"><?php the_excerpt(); ?></div>
						<?php comments_popup_link(__('No Comments yet.',THEMENAME), __('1 Comment.',THEMENAME), __('% Comments.',THEMENAME),"commentCount",null);?>
					</dd>
					<?php
					}
					?>
			</dl>
		</div>
		<ul id="scrollerLinks"><?php
			$first = true;
			foreach($highlightTitles as $highlightTitle) {
				$catItem = (function_exists("getFirstCatWithStyle") && ($catItem = getFirstCatWithStyle($highlightTitle[4])) ? " cat-item-".$catItem : "");?>
				<li class="<?php echo ($first ? "active" : "")?> cat-item<?php echo $catItem;?>">
					<a class="bob" href="<?php echo $highlightTitle[1];?>"><?php echo $highlightTitle[0]?></a>&nbsp;<a href="<?php echo $highlightTitle[1]?>">&raquo;</a>
					<div><?php echo $highlightTitle[3]."&nbsp;".$highlightTitle[2]?></div>
					<span class="clear"></span>
				</li>
				<?php
				$first = false;
			}?>
		</ul>
	</div><?php
}
$wp_query->is_page = true;
$wp_query->is_category = null;
/* END Scroller section */

// The categories you wish to show in this section
$showCats = array_filter((array)explode(",",get_post_meta($postID,"categories",true)),create_function('$a','return is_numeric($a);'));

if ($showCats) {
	// Add an exclude posts to the end of the query.
	if (function_exists("excludePostsFromSlider"))
		add_filter("posts_where","excludePostsFromSlider");
	$ICITposts = new WP_Query("showposts=7&cat=".implode(",",$showCats));

	remove_filter("posts_where","excludePostsFromSlider");
	unset ($prevSlider);
} else {
	unset ($ICITposts);
}

// Create a sort of manual loop for the first 3 posts the loop through the remaining.
if (is_object($ICITposts) && $ICITposts->have_posts()) {

	// First post from the categories
	$ICITposts->the_post();

	$image = (function_exists('PIPPGetImage') ? PIPPGetImage('medium',$post->ID,false,true) : null);

	if ($image)
		$image = '<a href="'.get_permalink().'" class="alignleft"><img src="'.$image.'" alt="'.sanitize_title(get_the_title(),"no-alt-text").'"/></a>';
	$catItem = (function_exists("getFirstCatWithStyle") && ($catItem = getFirstCatWithStyle($post->ID)) ? " cat-item-".$catItem : "");?>

	<h1 class="sectionTitle underline"><?php echo get_the_title($postID)?></h1>

	<div class="sectionLead">
		<?php echo $image; ?>
		<div class="postBody">
			<?php the_title("<h4><a href=\"".get_permalink()."\">","</a></h4>");?>
			<div class="postMeta bullet<?php echo $catItem;?>">
				<?php $previousday = null; the_date("",__('Posted on ',THEMENAME));?>
				<?php _e('by',THEMENAME);?> <a href="<?php echo get_author_posts_url(get_the_author_ID()); ?>"><?php the_author();?></a>
			</div>

			<?php the_excerpt();?>
				<a href="<?php the_permalink();?>" class="excerptReadMore"><?php _e('Read more',THEMENAME);?></a><br/>


		</div>
		<div class="clear"></div>
	</div>

	<?php
	// Second post from the categories
	if ($ICITposts->in_the_loop && $ICITposts->have_posts()) {
		$ICITposts->the_post();

		$image = (function_exists('PIPPGetImage') ? PIPPGetImage('thumbnail',$post->ID,false,true) : null);
		if ($image)
			$image = "<a href=\"".get_permalink()."\"><img src=\"$image\" alt=\"".sanitize_title(get_the_title(),"no-alt-text")."\" class=\"alignleft\" /></a>";
		$catItem = (function_exists("getFirstCatWithStyle") && ($catItem = getFirstCatWithStyle($post->ID)) ? " cat-item-".$catItem : "");?>

		<div class="sectionSecond">
			<div class="postBody">
				<?php the_title("<h4><a href=\"".get_permalink()."\">","</a></h4>");?>

				<div class="postMeta bullet<?php echo $catItem;?>">
					<?php $previousday = null; the_date("",__('Posted on ',THEMENAME));?>
					<?php _e('by',THEMENAME);?> <a href="<?php echo get_author_posts_url(get_the_author_ID()); ?>"><?php the_author();?></a>
				</div>
				<?php echo $image; ?>
				<?php the_excerpt();?>
				<a href="<?php the_permalink();?>" class="excerptReadMore"><?php _e('Read more',THEMENAME);?></a><br/>
			</div>
			<div class="clear"></div>
		</div>

		<?php
	}

	// Third post from the categories
	if ($ICITposts->in_the_loop && $ICITposts->have_posts()) {
		$ICITposts->the_post();

		$image = (function_exists('PIPPGetImage') ? PIPPGetImage('thumbnail',$post->ID,false,true) : null);
		if ($image)
			$image = "<a href=\"".get_permalink()."\"><img src=\"$image\" alt=\"".sanitize_title(get_the_title(),"no-alt-text")."\" class=\"alignleft\" /></a>";
		$catItem = (function_exists("getFirstCatWithStyle") && ($catItem = getFirstCatWithStyle($post->ID)) ? " cat-item-".$catItem : "");?>

		<div class="sectionThird">
			<div class="postBody">
				<?php the_title("<h4><a href=\"".get_permalink()."\">","</a></h4>");?>
				<div class="postMeta bullet<?php echo $catItem ?>">
					<?php $previousday = null; the_date("",__('Posted on ',THEMENAME));?>
					<?php _e('by',THEMENAME);?> <a href="<?php echo get_author_posts_url(get_the_author_ID()); ?>"><?php the_author();?></a>
				</div>
				<?php echo $image; ?>
				<?php the_excerpt();?>
				<a href="<?php the_permalink();?>" class="excerptReadMore"><?php _e('Read more',THEMENAME);?></a><br/>
			</div>
			<div class="clear"></div>
		</div>

		<?php
	}

	// The remaining post from the categories
	if ($ICITposts->in_the_loop && $ICITposts->have_posts()) { ?>
		<?php
		while ($ICITposts->have_posts()) {
			$ICITposts->the_post();
			$catItem = (function_exists("getFirstCatWithStyle") && ($catItem = getFirstCatWithStyle($post->ID)) ? " cat-item-".$catItem : "");?>

			<div class="postExcerpt sectionPost">
				<?php the_title("<h4><a href=\"".get_permalink()."\">","</a></h4>");?>

				<div class="postMeta bullet<?php echo $catItem ?>">
					<?php $previousday = null; the_date("",__('Posted on ',THEMENAME));?>
					<?php _e('by',THEMENAME);?> <a href="<?php echo get_author_posts_url(get_the_author_ID()); ?>"><?php the_author();?></a>
				</div>

				<div class="postBody">
				<?php

				$excerptThumb = (function_exists('PIPPGetImage') ? PIPPGetImage('excerptthumb',$post->ID,false,true) : null);
				if ($excerptThumb) {?>
					<a href="<?php the_permalink();?>">
						<img src="<?php echo $excerptThumb;?>" class="excetptThumb" alt="<?php echo sanitize_title(get_the_title(),"No Alt text");?>" width="64" height="64"/>
					</a>
					<?php
				}?>

				<?php the_excerpt();?>
				<a href="<?php the_permalink();?>" class="excerptReadMore"><?php _e('Read more',THEMENAME);?></a><br/>
				</div>
				<div class="clear"></div>
			</div>
			<?php
		}
	}

	if (is_array($showCats)) {?>
	<div id="sectionCatList">
		<h4 class="underline"><?php _e('More posts like these:',THEMENAME);?></h4>
		<ul>
			<?php wp_list_categories("title_li=&hierarchical=0&include=".implode(",",$showCats));?>
		</ul>
	</div>
	<?php
	}

// Basically if no categories are listed we may as well show the page.
} elseif (have_posts()) {

	while (have_posts()) {
		the_post();?>

		<div class="single<?php echo ($posts[0]->ID == $post->ID ? " firstPost" : "");?>">
			<?php the_title("<h1 class=\"sectionTitle underline\">","</h1>");?>
			<?php unset($firstCat); list($firstCat) = get_the_category(); ?>

			<div class="postBody">
				<?php
				the_content("&nbsp;&nbsp;".__('continue reading...',THEMENAME));
				wp_link_pages(array("before" => "<div class=\"pageLinks\">".__('Select a page',THEMENAME).":&nbsp", 'after' => "</div>", "next_or_number" => "number", "pagelink" => "<span>%</span>"));?>
			</div>
			<div class="clear"></div>
		</div><?php
		comments_template('/comments.php',true);
	}

// I'd be amazed if this be ever gets seen.
} else {?>
	<div class="post">
		<h2>Sorry something went very wrong.</h2>
		<p>Not sure how you got here? Well I'm not sure either.</p>
	</div><?php
}?>

</div>
<?php get_sidebar(); ?>
<span class="clear"></span>
</div>
<?php get_footer(); ?>
