<?php get_header();?>
<div id="content">
	<div id="posts" class="archive">
	<?php
	if (is_category()){?>
		<div class="archiveTitle bullet<?php echo ($cat ? " cat-item-$cat" : "");?>"><?php single_cat_title();?></div><?php
	} elseif (is_date()) {
		if (is_year()) { ?>
			<div class="archiveTitle bullet"><?php _e('All articles from',THEMENAME);?>: <?php echo the_time("Y"); ?></div><?php
		} elseif (is_month()) { ?>
			<div class="archiveTitle bullet"><?php _e('All articles from',THEMENAME);?>: <?php echo the_time("F, Y"); ?></div><?php
		} elseif (is_day()) { ?>
			<div class="archiveTitle bullet"><?php _e('All articles from',THEMENAME);?>: <?php echo the_time("l, F jS, Y"); ?></div><?php
		}
	} elseif (is_author()) {?>
		<div class="archiveTitle bullet"><?php _e('All articles by',THEMENAME);?>: <?php echo get_author_name((int) get_query_var("author"));?></div><?php
	}?>

	<?php
	if (have_posts()) {
		while (have_posts()) {
			the_post();?>
			<div class="postExcerpt<?php echo ($posts[0]->ID == $post->ID ? " firstPost" : "");?>">
				<?php
				the_title("<h4><a href=\"".get_permalink()."\">","</a></h4>");
				if ( function_exists("getFirstCatWithStyle") && ($catItem = getFirstCatWithStyle()) )
					$catItem = (is_object($SpectacuLATheme) && in_array($cat,array_keys((array)$SpectacuLATheme->bulletStyle["cat"])) ? " cat-item-{$cat}" : " cat-item-".$catItem );?>

				<div class="postMeta bullet<?php echo $catItem;?>">
					<?php
					$previousday = null; the_date("",__('Posted on ',THEMENAME));?>
					<?php _e('by',THEMENAME);?> <a href="<?php echo get_author_posts_url(get_the_author_ID()); ?>"><?php the_author();?></a>
					<?php comments_popup_link(__('and has no comments yet.',THEMENAME), __(' and has 1 comment.',THEMENAME), __(' and has % comments.',THEMENAME),"","");?>
					<?php edit_post_link(__('Edit',THEMENAME),"&nbsp;&nbsp;&nbsp;&nbsp;(",")"); ?>
				</div>

				<div class="postBody">
					<?php
					$excerptThumb = (function_exists('PIPPGetImage') ? PIPPGetImage('excerptthumb','-1',false,true) : null);
					if ($excerptThumb) {?>
						<a href="<?php the_permalink();?>">
							<img src="<?php echo $excerptThumb;?>" class="excetptThumb" alt="<?php echo sanitize_title(get_the_title(),"No Alt text");?>" width="64" height="64"/>
						</a>
						<?php
					}?>

					<?php the_excerpt();?>
					<a href="<?php the_permalink();?>" class="excerptReadMore"><?php _e('Read more',THEMENAME);?></a><br/>
				</div>
				<div class="clear"></div>

			</div><?php
		}
	} else {?>
		<div class="postBody search">
			<h2>Sorry no pages matching your request were found.</h2>
			<p>Either hit the back button on your browser or use this search form to find what you where looking for.</p>
			<?php include (TEMPLATEPATH."/searchform.php");?>
		</div><?php
	}
	global $wp_query; /* To avoid orphaned tags showing up when there is no need for post_nav_link() the following checks for the need of it. */
	if ( $wp_query->max_num_pages > 1 && !is_singular()) {?>
		<div id="pageNavigation">
			<div id="previousPosts"><?php previous_posts_link();?></div>
			<div id="nextPosts"><?php next_posts_link();?></div>
		</div><?php
	}?>
	</div>
	<?php get_sidebar(); ?>
	<span class="clear"></span>
</div>
<?php get_footer(); ?>
