	function getWindowHeight(){
		if(usr.Mac && (usr.checkObj == 1 || usr.OPERA)){
			return window.innerHeight;
		}else if(usr.Win && usr.checkObj == 1){
			return window.innerHeight - 16;
		}else if(usr.checkObj == 4){
			return window.innerHeight - 15;
		}else if(usr.OPERA || usr.checkObj == 2 || usr.checkObj == 3){
			return d.body.clientHeight;
		}
	}

	function getWindowXOffset(){
		if(usr.checkObj == 2 || usr.checkObj == 3){
			return d.body.scrollLeft;
		}else if(usr.checkObj == 1 || usr.checkObj == 4){
			return window.pageXOffset;
		}
	}
	function getWindowYOffset(){
		if(usr.checkObj == 2 || usr.checkObj == 3){
			return d.body.scrollTop;
		}else if(usr.checkObj == 1 || usr.checkObj == 4){
			return window.pageYOffset;
		}
	}

	function getDocHeight(){
		if(usr.checkObj == 1){
			return getTagTop('end') + 1;
		}else if(usr.checkObj == 2 || usr.checkObj == 3 || usr.checkObj == 4){
			return getTagTop('end');
		}
	}

	function getDistanceMaxY(){
		if(usr.allObj){
			return (getDocHeight() - getWindowHeight());
		}
	}

	function setObj(idName){
		return d.all ? d.all(idName) : d.getElementById ? d.getElementById(idName) : d.layers[idName];
	}

	function getTagTop(idName) {
		var obj = setObj(idName);
		var tagCoords = new Object();

		if((usr.checkObj == 2) || (usr.checkObj == 3) || (usr.checkObj == 4)) {
			tagCoords.y = obj.offsetTop;
			while ((obj = obj.offsetParent) != null) {
				tagCoords.y += obj.offsetTop;
			}if(usr.Mac && usr.Moz){
				return tagCoords.y - 12;
			}else if((usr.Win && usr.Moz) || (usr.Mac && usr.SAFARI)){
				return tagCoords.y - 9;
			}else{
				return tagCoords.y;
			}
		} else if(usr.checkObj == 1) {
			tagCoords.y = d.anchors[idName].y;
			return tagCoords.y;
		}return idName;
	}

	/*PageScroller*/
	var pageScrollTimer;
	function pageScroll(toX,toY,frms,frX,frY) {
		if(pageScrollTimer) clearTimeout(pageScrollTimer);
		var spd = usr.Mac ? 14 :16;
		var actX = getWindowXOffset();
		var actY = getWindowYOffset();
		if(!toX || toX < 0) toX = 0;
		if(!toY || toY < 0) toY = 0;
		if(!frms) frms = usr.NN ? 10 :usr.Mac ? 4 :5;
		if(!frX) frX = 0 + actX;
		if(!frY) frY = 0 + actY;

		frX += (toX - actX) / frms;
		if (frX < 0) frX = 0;
		frY += (toY - actY) / frms;
		if (frY < 0) frY = 0;
		var posX = Math.ceil(frX);
		var posY = Math.ceil(frY);
		window.scrollTo(posX, posY);
		if((Math.floor(Math.abs(actX - toX)) < 1) && (Math.floor(Math.abs(actY - toY)) < 1)){
			clearTimeout(pageScrollTimer);
			window.scroll(toX,toY);
		}else if(posX != toX || posY != toY){
			pageScrollTimer = setTimeout("pageScroll("+toX+","+toY+","+frms+","+frX+","+frY+")",spd);
		}else{
			clearTimeout(pageScrollTimer);
		}
	}

	function jumpToAnchor(idName) {
		if(usr.allObj){
			if(!!idName){
				var anchorY = getTagTop(idName);
				var dMaxY = getDistanceMaxY();
				var setY = (anchorY<10)?0:(anchorY>dMaxY)?dMaxY:anchorY;
				if(anchorY>10){
					pageScroll(0,setY);
				}else if(anchorY<=10){
					pageScroll(0,0);
				}else{
					location.hash = idName;
				}
			}else{
				pageScroll(0,0);
			}
		}else{
			!!idName ? location.hash = idName : location.hash = "top";
		}
	}
	function jumpToPageTop() {
		if(usr.allObj){
			pageScroll(0,0);
		}else{
			!!idName ? location.hash = idName : location.hash = "top";
		}
	}
