var errorText 			= behaviourL10n.searchError,
	searchText			= behaviourL10n.searchPrompt+' '; //Stick a space on the end so someone can search for the search prompt if they need to.

jQuery(document).ready(function($){

	// Horizontal scroller.
	var width = $("#scrollerWindow dl dd").width() + 20,
		count = $("#scrollerWindow dl dd").size(),
		previousPost = 0,
		scrollChangeRate = 7000, // 7 seconds
		scrollChangeInterval = setInterval(nextPost,scrollChangeRate);
	$("#scrollerWindow dl").css({width:count * width})			// Set the width of the container

	function nextPost() {
		scrollToPost((previousPost + 1) % count);
	}

	function scrollToPost(i){
		clearInterval(scrollChangeInterval);

		if (previousPost != i)
			$("#scrollerWindow dl").stop();

		$("#scrollerLinks").children("li").removeClass("active");
		$("#scrollerLinks li a.bob:eq("+i+")").parent("li").addClass("active");
		$("#scrollerWindow dl").animate({left:"-"+i*width+"px"},{duration:1000});

		scrollChangeInterval = setInterval(nextPost,scrollChangeRate);

		previousPost = i;
		return true;
	}

	$("#scrollerLinks li a.bob").each(function(i){
		$(this).click(function() {
			scrollToPost(i);
			return false;
		})
	});

	// Pause on mouse over scrollerWindow.
	$("#scrollerWindow").hover(function(){
		clearInterval(scrollChangeInterval);
		$("#scroller .pause").fadeIn(500);
	},function(){
		clearInterval(scrollChangeInterval);
		scrollChangeInterval = setInterval(nextPost,scrollChangeRate);
		$("#scroller .pause").fadeOut(500);
	});

	//Search Widget
	$('input[name=s]').each(function(){
		$(this).addClass('unfocused');
		if ($(this).attr('value') === '' || $(this).attr('value') === undefined) {
			$(this).attr({value:searchText});
		}

		$(this).focus(function(){
			if ($(this).attr('value') == searchText){
				$(this).attr({value:''});
			}
			$(this).addClass('focused').removeClass('unfocused');
		});

		$(this).blur(function(){
			if ($(this).attr('value') === '' || $(this).attr('value') === undefined){
				$(this).attr({value:searchText});
			}
			$(this).removeClass('focused').addClass('unfocused');
		});
	});

	// Stop search submission if nothing has been entered in the search box
	$('form:has(input[name=s])').submit(function(){
		var searchField = $(this).find('input[name=s]');

		if (searchField.attr('value') === '' || searchField.attr('value') === searchText || searchField.attr('value') === undefined) {
			$('body').append('<p class="errorMessage">'+errorText+'</p>').children('.errorMessage').css({opacity:0,position:'absolute',top:searchField.offset().top - ($(this).height() - (searchField.height()+10)),left:searchField.offset().left + (searchField.width() * 0.1)}).animate({opacity:1},250).animate({opacity:1},750).animate({opacity:0},1000,'swing',function(){
				$(this).remove();
			});
			return false;
		} else {
			return true;
		}
	});

	$("input[type='submit']").addClass("submit");

	// Zebra stripe tables the easy way.
	$(".postBody table tr:odd").addClass("alternate");

	// Fix some IE 6 problems. The sooner ie6 dies the better
	$.each($.browser, function(i, val) {
		if(i=="msie" && val == true && $.browser.version.substr(0,1) == 6){
			$("#navList li").hover(function(){$(this).addClass("over");},function(){$(this).removeClass("over");});
			$("#importantPages li").hover(function(){$(this).addClass("over");},function(){$(this).removeClass("over");});
		}
		if(!$.boxModel){
			theBody = document.getElementsByTagName("BODY");
			theBody[0].className+=" quirky";
		}
	});
});
